-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.smallTown:LinkToTarget("questSmallTown")
    Debug:Log("Small town initialized")
  end
end

function OnBeforeDeath(self)
  self.smallTown:TriggerAllTargets()
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("smallTown")
end
